/**************************************************************************
 * \file: adit_dlt.h
 *
 * \version: $Id: adit_dlt.h,v 1.0 2013/11/11 15:02:20 bkebianyor Exp $
 *
 * This files maintains a list of all Application IDs for DLT Applications
 * in the ADIT platform. This includes ADIT owned Applications, GENIVI and other
 * 3rd Party Application delivered as part of Middleware.
 *
 * \component: global definition file
 *
 * \author: Bewoayia Kebianyor <bkebianyor@de.adit-jv.com>
 *
 * \copyright: (c) 2003 - 2009 ADIT Corporation
 *
 *************************************************************************/

#ifndef ADIT_DLT_H
#define ADIT_DLT_H


/**************************************************************************
 * GENIVI Application IDs
 ************************************************************************* /

- * DLT Help Components/ Adaptors **/
#define GENIVI_DLT_SYSTEM                   "SYS"
#define GENIVI_DLT_ADP_STDIN                "SINA"
#define GENIVI_DLT_ADP_UDP                  "UDPA"

/* Other Components **/
#define GENIVI_LAYERMANAGER                 "LMSA"       /* layer_management/LayerManagerUtils,          11-11-2013 */





       /* DLT Test / Examples **/
#define GENIVI_EXAMPLE_FILETRANSFER         "FLTR"
#define GENIVI_EXAMPLE_USER                 "LOG"
#define GENIVI_TEST_FILETRANSFER            "FLTR"          /*  dlt-daemon/src/test,
                                                                lta/test/dlt/tdlt,  */
#define GENIVI_TEST_USER                    "DIFT"          /*  dlt-daemon/src/test,
                                                                lta/test/dlt/tdlt,  */
#define GENIVI_TEST_STRESS                  "DSTS"          /*  dlt-daemon/src/test,
                                                                lta/test/dlt/tdlt,  */
#define GENIVI_TEST_STRESS_USER             "DIFT"          /*  dlt-daemon/src/test,
                                                                lta/test/dlt/tdlt,  */
#define GENIVI_TEST_MULTI_PROCESS           "MT"            /*  dlt-daemon/src/test,
                                                                 lta/test/dlt/tdlt,  */
#define GENIVI_TEST_LOG_STORAGE             "DLST"

/**************************************************************************
 * 3rd Party Application IDs SECTION
 *************************************************************************/

#define THIRD_PARTY_TEST_LOG_APP  "TEST_APID"


/**************************************************************************
 * ADIT  Application IDs
 *************************************************************************
 **
 * Definitions for ADIT DLT APID
 *
 * An Application ID is specified as a 4 Bytes Alphanumeric character with
 * and assigned as follows:
 *
 * [   "ADIT Component Identifier "     ][  Component Specific ID     ]
 * [0                                  8][9                         32]
 * [             "A"                    ][ Each byte value "0-9","A-Z"]
 *
 *
 * 2nd, 3rd and 4th Bytes.These will be alphanumeric characters (0 -9 to A-Z).
 *
 *
 *   Please comment each update with the following template:
 *  <Application path> <Application ShortName>, <date of entry>
 */

#define DLT_TRACE_DLT_BE_APID           "TRBE"  /* trace/platform/trace/trace_dlt_be, "TRACE Backend"  11-11-2013 */
#define DLT_MYSPIN_APP_APID             "MYSP"  /* myspin/demo/mspin_target_adapter,           11-11-2013 */
#define DLT_ERRMEM_DLT_BE_APID          "ERRM"  /* adit-userland/platform/errmem/errmemd,      12-11-2013 */
#define DLT_EXCHD_DLT_BE_APID           "EXHD"  /* adit-userland/platform/exchnd/exchndd,      12-11-2013 */
#define DLT_IPOD_IAP2_APID              "IAP2"  /* ipod/platform/iAP2/interface,               12-11-2013 */
#define DLT_IPOD_IAP1_APID              "IAP1"  /* ipod/platform/iAP1/interface,               18-05-2015 */
#define DLT_IPOD_IAP_APID               "IAP"   /* Common APPId for IAP1 and IAP2              18-05-2015 */
#define DLT_SVG_COMP_APID               "SVGC"  /* graphics/platform/svg_font                  12-05-2015 */

#define DLT_MLINK_APID                  "MLNK"  /* mlink/platform/mlink-adapter,               12-11-2013 */
#define DLT_GALCORE_APID                "GLCR"  /*imx-drv-src/gpu-viv-src-mx6q/driver "Galcore GPU lib" 19-12-2013 */
#define DLT_IPOD_PLAYER_APID            "IPOD"  /* ipod/platform/ipod_player,                  06-01-2014 */
#define DLT_CARPLAY_APID                "CPLY"  /* cplay/platform/carplayd                     13-03-2014 */
#define DLT_QT5_APID                    "QT5"   /* supplier/mgc/drop/2014-05.git]/downloads/  23-06-2016 */
#define DLT_DLNA_DEVD_APID              "DLDD"  /* supplier / OSS / rygel.git 26-06-2016*/
#define DLT_DLNA_DMS_APID               "DLMS"  /* supplier / mgc / drop /  - dLeyna-server  26-06-2016 */
#define DLT_DLNA_DMR_APID               "DLMR"  /* supplier / mgc / drop / - dLeyna-renderer 26-06-201 */

/* Test Applications **/
#define DLT_LTA_TEST_GENIVI             "TLTA"    /* lta/test/genivi/DLT/DLT/,                    12-11-2013 */
#define DLT_LTA_TEST_DLT_OFFLINE        "TLGS"    /* lta/test/dlt/tdlt/src/dlt-test-offline-trace 12-11-2013 */
#define DLT_MYSPIN_TEST_AOAP            "AOAP"    /* /myspin/test/aoap/aoap_test/                 12-11-2013 */
#define DLT_LTA_TEST_DLT                "TDLT"    /* /lta/test/dlt/tdlt/                          29-11-2013 */
#define DLT_TEST_CARPLAY_APID           "TCPL"    /* cplay/test/carplay-test                      13-03-2014 */


/* Example Entry
#define COMPONENT_SHORT_NAME_APID       "Next APID  e.g A9"   / * component_path,                DD-MM-YYYY */


#endif /* ADIT_DLT_H */
